##################################################################################################
###                                 Supplementary material to                                  ###
### A new confidence interval based on the theory of U-statistics for the area under the curve ###
###                 by J. Kampf, L. Vogel, I. Dykun, T. Rassaf and A. Mahabadi                 ###
##################################################################################################


### Here we present the simulations for the binormal model 
### the bias and the standard deviation of the AUC
### (Table 15 of the article)


library(pROC)

n_1=c(10, 100, 1000, 10, 100, 1000)
n_2=c(10, 100, 1000, 10, 100, 1000)
mu_1=0
mu_2=c(1,1,1,2,2,2)
sigma=1

N_conf =10^4

bias = rep(0, 6)  # vector to store the biases of the AUC
stdv = rep(0, 6)  # vector to store the standard deviations


set.seed(2)

### Let us calculate the theoretical AUC P(Y_1<Y_2 | I_1=0, I_2=1 )
AUC_theoretical = pnorm(mu_2-mu_1, mean=0, sd=sqrt(2)*sigma)


# Now simulate the realisations

for(k in (1:6)){
  
  AUC_empirical = rep(0, N_conf)
      # Vector to store the empirical AUCs

  for(i in (1:N_conf)){
    
    set.seed(i)    
    
    # Simulate for n_1[k] control observations and n_2[k] case observations
    # fitted values according to the binormal model
    target_test = c(rep(0,n_1[k]), rep(1, n_2[k]))
    fitted_test = c(rnorm(n_1[k], mean=mu_1, sd=sigma), 
                    rnorm(n_2[k], mean=mu_2[k], sd=sigma))
    
    AUC_empirical[i] = auc(target_test, fitted_test)
    }
  
  # Control: Is everything working alright?
  print(k)
  
  bias[k] = abs(mean(AUC_empirical)-AUC_theoretical[k])
  stdv[k] = sd(AUC_empirical)
  }#k


df=as.data.frame( cbind (c(" ", " ", "bias", "standard deviation"),
                         rbind(n_1+n_2, (mu_2-mu_1)/sigma, 
                               format(bias, digits=3), format(stdv, digits=3))))
print(Sys.time())

library(xtable)

xtable(df)