##################################################################################################
###                                 Supplementary material to                                  ###
### A new confidence interval based on the theory of U-statistics for the area under the curve ###
###                 by J. Kampf, L. Vogel, I. Dykun, T. Rassaf and A. Mahabadi                 ###
##################################################################################################


### Here we present the simulations for the binormal model 
### (Table 1 and 2 of the article)


#####################################################################
####                          ATTENTION!                         ####
#### The following program takes 13 hours on a 2.5 GHz computer. ####
#### If you do not have that much time, decrease N_conf.         ####
#####################################################################


source("AUC_CI.R")

n_1=c(10, 100, 1000, 10, 100, 1000)
n_2=c(10, 100, 1000, 10, 100, 1000)
mu_1=0
mu_2=c(1,1,1,2,2,2)
sigma=1

N_conf =10^4

covered     = array(0, dim=c(4,6))  # Array to store the coverage probability
mean_length = array(0, dim=c(4,6))  # Array to store the mean length


set.seed(2)

### Let us calculate the theoretical AUC P(Y_1<Y_2 | I_1=0, I_2=1 )
AUC_theoretical = pnorm(mu_2-mu_1, mean=0, sd=sqrt(2)*sigma)


# Now simulate the confidence intervals

for(k in (1:6)){
  
  interval =array(0, dim=c(4,N_conf,2))
      # Array to store the confidence intervals
          # First component: Which algorithm? (Corollary 2 / Corollary 3
          #                                   DeLong / modified Wald)
          # Second component: Which simulation run (i.e. which seed)?
          # Third component: Which endpoint? (left/right)
  
  for(i in (1:N_conf)){
    
    set.seed(i)    
    
    # Simulate for n_1[k] control observations and n_2[k] case observations
    # fitted values according to the binormal model
    target_test = c(rep(0,n_1[k]), rep(1, n_2[k]))
    fitted_test = c(rnorm(n_1[k], mean=mu_1, sd=sigma), 
                    rnorm(n_2[k], mean=mu_2[k], sd=sigma))
    
    interval[1,i,]=AUC_new2(target_test, fitted_test)
    interval[2,i,]=AUC_new3(target_test, fitted_test)
    interval[3,i,]=AUC_DeLong(target_test, fitted_test)
    interval[4,i,]=AUC_MWald(target_test, fitted_test)
  }
  
  # Control: Is everything working alright?
  print(k)
  if(sum(is.na(interval))>0){
    stop(paste(k,i,which(is.na(interval))))
  }
  
  
  covered[,k]  = apply( (interval[,,1]<AUC_theoretical[k]) & (interval[,,2]>AUC_theoretical[k]),
                        1, mean)
  
  
  mean_length[,k] =apply(interval[,,2]-interval[,,1], 1, mean)
}#k


covered_df=as.data.frame( cbind (c(" ", " ", "Corollary 2", "Corollary 3",
                                   "DeLong", "Modified Wald"),
                                 rbind(n_1+n_2, (mu_2-mu_1)/sigma, format(covered, digits=3))))
mean_length_df=as.data.frame( cbind (c(" ", " ",  "Corollary 2", "Corollary 3",
                                       "DeLong", "Modified Wald"),
                               rbind(n_1+n_2, (mu_2-mu_1)/sigma, format(mean_length, digits=3))))


library(xtable)

xtable(covered_df)

xtable(mean_length_df)